﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
using System.Security.AccessControl;
using System.DirectoryServices.AccountManagement;

namespace SWAT_Office_App
{
    class Manage_User_Accounts
    {
        private static string studentGroupName = "StudentAccounts";
        public static List<UserPrincipal> UserAccountsList = new List<UserPrincipal>();
        public static bool AddUser(string username, string password)
        {
            try
            {
                PrincipalContext localSystem = new PrincipalContext(ContextType.Machine);
                // Creates a new user after checking if it already exists or not
                UserPrincipal newUser = new UserPrincipal(localSystem);
                newUser.Name = username;
                PrincipalSearcher searcher = new PrincipalSearcher(newUser);
                Principal result = searcher.FindOne();
                if (result == null)
                {
                    newUser = new UserPrincipal(localSystem);
                    newUser.Name = username;
                    newUser.SetPassword(password);
                    newUser.PasswordNeverExpires = true;
                    newUser.PasswordNotRequired = false;
                    newUser.UserCannotChangePassword = true;
                    newUser.Description = DateTime.Now.ToShortDateString();
                    newUser.Save();

                    // Creates a new group after checking if it already exists or not
                    GroupPrincipal studentGroup = new GroupPrincipal(localSystem);
                    studentGroup.Name = studentGroupName;
                    searcher = new PrincipalSearcher(studentGroup);
                    result = searcher.FindOne();
                    // Creates group if it doesnt already exist
                    if (result == null)
                    {
                        studentGroup = new GroupPrincipal(localSystem, studentGroupName);
                        studentGroup.Name = studentGroupName;
                        studentGroup.IsSecurityGroup = true;
                        studentGroup.Members.Add(newUser);
                        studentGroup.Save();
                    }
                    // Otherwise add to existing group
                    else
                    {
                        studentGroup = (GroupPrincipal)result;
                        studentGroup.Members.Add(newUser);
                        studentGroup.Save();
                    }
                    Debug.appendText("Account " + username + " has been created");
                    Stat_Logging.AccountsCreated += 1;
                    return true;
                }
                else
                {
                    // local account already exists, return with error
                    return false;
                }
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static bool DeleteUser(List<string> usernames)
        {
            try
            {
                bool Success = true;
                PrincipalContext localSystem = new PrincipalContext(ContextType.Machine);
                // Iterates through and deletes selected users
                foreach (string user in usernames)
                {
                    bool deleteShare = false;
                    if (Directory.Exists(Settings_Form.sharedFolderLocation + @"\" + user))
                    {
                        // Prompts for deletion of folder as well as the user account
                        DialogResult result = MessageBox.Show("A shared folder exists for the user " + user + "!" +
                            "\nDelete the folder and all data within the folder?",
                           "Warning!", MessageBoxButtons.YesNo);
                        if (result == DialogResult.Yes)
                            deleteShare = true;
                    }
                    // Finds and deletes user and share
                    UserPrincipal toDelete = new UserPrincipal(localSystem);
                    toDelete.Name = user;
                    PrincipalSearcher searcher = new PrincipalSearcher(toDelete);
                    Principal found = searcher.FindOne();
                    toDelete = (UserPrincipal)found;
                    toDelete.Delete();
                    Debug.appendText("Account " + user + " has been deleted");
                    // Deletes share if selected
                    if (deleteShare)
                        if (!DeleteShareFolder(user))
                            Success = false;
                }
                return Success;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static bool QueryUserAccounts()
        {
            // Function that reads the user accounts on the local computer to UserAccountsList
            UserAccountsList.Clear();
            try
            {
                PrincipalContext localSystem = new PrincipalContext(ContextType.Machine);
                UserPrincipal user = new UserPrincipal(localSystem);
                user.Name = "*";
                PrincipalSearcher searcher = new PrincipalSearcher(user);
                PrincipalSearchResult<Principal> result = searcher.FindAll();
                foreach (Principal p in result)
                    UserAccountsList.Add((UserPrincipal)p);
                return true;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static bool QueryUserSharedFolderExist(string username)
        {
            return Directory.Exists(Settings_Form.sharedFolderLocation + @"\" + username);
        }
        public static bool CreateShareFolder(string username)
        {
            
            try
            {
                // Creates the directory with only the specific NTFS and share permissions for the user.
                DirectorySecurity dSecurity = new DirectorySecurity();
                // Adds NTFS permissions for system accounts
                foreach (string systemUser in Settings_Form.systemAccounts)
                {
                    dSecurity.AddAccessRule(new FileSystemAccessRule("\\" + systemUser, FileSystemRights.FullControl, InheritanceFlags.ContainerInherit, PropagationFlags.None, AccessControlType.Allow));
                    dSecurity.AddAccessRule(new FileSystemAccessRule("\\" + systemUser, FileSystemRights.FullControl, InheritanceFlags.ObjectInherit, PropagationFlags.None, AccessControlType.Allow));
                }
                // Adds NTFS permissions for the user
                dSecurity.AddAccessRule(new FileSystemAccessRule("\\" + username, FileSystemRights.FullControl, InheritanceFlags.ContainerInherit, PropagationFlags.None, AccessControlType.Allow));
                dSecurity.AddAccessRule(new FileSystemAccessRule("\\" + username, FileSystemRights.FullControl, InheritanceFlags.ObjectInherit, PropagationFlags.None, AccessControlType.Allow));
                Directory.CreateDirectory(Settings_Form.sharedFolderLocation + @"\" + username, dSecurity);
                Debug.appendText("Shared folder for " + username + " has been created");
                if (SetSharePermissions(username))
                {
                    Stat_Logging.SharesCreated += 1;
                    return true;
                }
                else
                    return false;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static bool DeleteShareFolder(string username)
        {
            try
            {
                bool Success = true;
                // Removes the share BEFORE deleting the folder. Otherwise share will error on remove.
                if (!RemoveSharePermissions(username))
                    Success = false;
                Directory.Delete(Settings_Form.sharedFolderLocation + @"\" + username, true);
                Debug.appendText("Shared folder for " + username + " has been deleted");
                return Success;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static bool ToggleShare(string username)
        {
            try
            {
                // Checks if a share already exists for the user
                if (Directory.Exists(Settings_Form.sharedFolderLocation + @"\" + username))
                {
                    DialogResult result = MessageBox.Show("A shared folder exists for the user " + username + "!" +
                                "\nDelete the folder and all data within the folder?",
                               "Warning!", MessageBoxButtons.YesNo);
                    if (result == DialogResult.Yes)
                        return DeleteShareFolder(username);
                }
                // Otherwise creates the share for the user
                else
                    return CreateShareFolder(username);
                return true;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static long GetShareSize(string username)
        {
            DirectoryInfo dir = new DirectoryInfo(Settings_Form.sharedFolderLocation + @"\" + username);
            long size = GetDirSize(dir);
            return size;
        }
        private static long GetDirSize(DirectoryInfo input)
        {
            try
            {
                if (input.Exists)
                {
                    long size = 0;
                    FileInfo[] files = input.GetFiles();
                    foreach (FileInfo file in files)
                    {
                        size += file.Length;
                    }
                    DirectoryInfo[] dirs = input.GetDirectories();
                    foreach (DirectoryInfo dir in dirs)
                    {
                        size += GetDirSize(dir);
                    }
                    return size;
                }
                else 
                    return 0;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return 0;
            }
        }
        public static bool ChangeUserPassword(string username, string password)
        {
            try
            {
                // Queries for the specified user password
                PrincipalContext localSystem = new PrincipalContext(ContextType.Machine);
                UserPrincipal user = new UserPrincipal(localSystem);
                user.Name = username;
                PrincipalSearcher searcher = new PrincipalSearcher(user);
                Principal result = searcher.FindOne();
                user = (UserPrincipal)result;
                user.SetPassword(password);
                user.Save();
                Debug.appendText("Password for " + username + " has been changed");
                return true;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        public static bool SessionsOpen()
        {
            try
            {
                Process netProcess = new Process();
                netProcess.StartInfo.WorkingDirectory = System.Environment.SystemDirectory;
                netProcess.StartInfo.FileName = "net.exe";
                netProcess.StartInfo.UseShellExecute = false;
                netProcess.StartInfo.RedirectStandardOutput = true;
                netProcess.StartInfo.CreateNoWindow = true;
                netProcess.StartInfo.Arguments = "SESSION";
                netProcess.Start();
                string netOutput = netProcess.StandardOutput.ReadToEnd();
                // Splits the output into seperate strings for further processing
                string[] tempSplit = netOutput.Split(new string[] { "  ", "\r", "\n" }, StringSplitOptions.RemoveEmptyEntries);
                netProcess.WaitForExit();
                netProcess.Close();

                if (tempSplit[0] == "There are no entries in the list.")
                    return false;
                else
                    return true;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return true;
            }
        }
        private static bool SetSharePermissions(string username)
        {
            string combinationString = "";
            foreach (string systemUser in Settings_Form.systemAccounts)
            {
                combinationString = combinationString.Insert(combinationString.Length, " /GRANT:\"" + systemUser + "\",FULL");
            }
            combinationString = combinationString.Insert(combinationString.Length, " /GRANT:\"" + username + "\",FULL");
            try
            {
                Process netProcess = new Process();
                netProcess.StartInfo.WorkingDirectory = System.Environment.SystemDirectory;
                netProcess.StartInfo.FileName = "net.exe";
                netProcess.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                netProcess.StartInfo.CreateNoWindow = true;
                netProcess.StartInfo.Arguments = "SHARE \"" + username + "\"=\"" + Settings_Form.sharedFolderLocation + "\\" + username + "\" " + combinationString;
                netProcess.Start();
                netProcess.WaitForExit();
                netProcess.Close();
                Debug.appendText("Share permissions for " + username + " has been set");
                return true;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
        private static bool RemoveSharePermissions(string username)
        {
            try
            {
                Process netProcess = new Process();
                netProcess.StartInfo.WorkingDirectory = System.Environment.SystemDirectory;
                netProcess.StartInfo.FileName = "net.exe";
                netProcess.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
                netProcess.StartInfo.CreateNoWindow = true;
                netProcess.StartInfo.Arguments = "SHARE \"" + username + "\" /Delete";
                netProcess.Start();
                netProcess.WaitForExit();
                netProcess.Close();
                Debug.appendText("Share permissions for " + username + " has been removed");
                return true;
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
                return false;
            }
        }
    }
}
